//
//  VideoViewController.m
//  AdViewSDKDemo
//
//  Created by unakayou on 11/1/19.
//  Copyright © 2019 AdView. All rights reserved.
//

#import "VideoViewController.h"

@interface VideoViewController () <AdViewVideoDelegate>
@property (nonatomic, strong) AdViewVideo * video;
@end

@implementation VideoViewController

- (void)requestButtonClick:(UIButton *)sender {
    self.video = [AdViewVideo playVideoWithAppId:ADVIEW_APPID
                                      positionId:ADVIEW_POSID_VIDEO
                                       videoType:AdViewVideoTypeInstl
                                        delegate:self];
    [self.video setInterfaceOrientations:[UIApplication sharedApplication].statusBarOrientation];
    [self.video getVideoAD];
}

- (void)adViewVideoDidReceiveAd:(NSString *)vastString {
    NSLog(@"%@",vastString);
}

- (void)adViewVideoIsReadyToPlay:(AdViewVideo *)video {
    [video showVideoWithController:self];
}

- (void)adViewVideoFailReceiveDataWithError:(NSError *)error {
    NSLog(@"%s - %@",__FUNCTION__, error.domain);
}

- (void)adViewVideoPlayStarted {
    NSLog(@"%s", __FUNCTION__);
}

- (void)adViewVideoPlayEnded {
    NSLog(@"%s", __FUNCTION__);
}
- (void)adViewVideoSkipped {
    NSLog(@"%s", __FUNCTION__);
}
- (void)adViewVideoClosed {
    NSLog(@"%s", __FUNCTION__);
}

@end
