//
//  SpreadViewController.m
//  AdViewSDKDemo
//
//  Created by unakayou on 11/1/19.
//  Copyright © 2019 AdView. All rights reserved.
//

#import "SpreadViewController.h"

@interface SpreadViewController () <AdViewViewDelegate>
@property (nonatomic, strong) AdViewView * spread;
@end

@implementation SpreadViewController

- (void)requestButtonClick:(UIButton *)sender {
    self.spread = [AdViewView requestSpreadActivityWithPositionId:ADVIEW_POSID_SPREAD delegate:self];
}

- (NSString *)appId {
    return ADVIEW_APPID;
}

- (UIViewController *)viewControllerForShowModal {
    return [[[UIApplication sharedApplication] keyWindow] rootViewController];
}

//- (NSString *)logoImgName {
//    return @"";
//}

- (BOOL)testMode {
    return NO;
}

- (void)didReceivedAd:(AdViewView *)adView {
    NSLog(@"%s - %@",__FUNCTION__, adView);
}

- (void)didFailToReceiveAd:(AdViewView *)adView Error:(NSError *)error {
    NSLog(@"%s - %@",__FUNCTION__, error);
}
- (void)adViewDidDisplayAd:(AdViewView *)adView {
    
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"Already Displayed");
}
- (void)adViewdidFailToDisplayAd:(AdViewView *)adView Error:(NSError*)error {
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"%@", error);
    
}

@end
