#import "AdViewDefinesPublic.h"

@class AdViewView;
@protocol AdViewGDPRProcotolV1;
@protocol AdViewGDPRProcotolV2;
@protocol AdViewBidModeProtocol;

@protocol AdViewViewDelegate <AdViewGDPRProcotolV1, AdViewGDPRProcotolV2, AdViewBidModeProtocol>
@required
/**
 The application id, you can register here: http://www.adview.com/web/overseas

 @return appid
 */
- (NSString *)appId;

/**
 Show Ad in this viewController or viewController.view

 @return a present viewController
 */
- (UIViewController *)viewControllerForShowModal;

@optional

/**
 * Ad request success
 */
- (void)didReceivedAd:(AdViewView *)adView;

/**
 * Ad request faild
 */
- (void)didFailToReceiveAd:(AdViewView *)adView Error:(NSError*)error;
/**
 Ad displayed

 @param adView The Adview
 */
- (void)adViewDidDisplayAd:(AdViewView *)adView;
/**
 Ad Display faild

 @param adView The Adview
 */
- (void)adViewdidFailToDisplayAd:(AdViewView *)adView Error:(NSError*)error;

/**
 Ad PresentScreen Clicked

 @param adView The Adview
 */
- (void)adViewWillPresentScreen:(AdViewView *)adView;

/**
 Ad dismissed

 @param adView The Adview
 */
- (void)adViewDidDismissScreen:(AdViewView *)adView;


/**
 MREC Video did finished show, you can close Ad or request new Ad again

 @param adview The Adview
 */
- (void)adViewDidFinishShow:(AdViewView *)adview;

/**
 MREC Video did finished show, you can close Ad by closeBtn

 @param adview The Adview
 */
- (void)adViewVideoClosed:(AdViewView *)adview;

/**
 Useless
 
 @return NSString
 */
- (NSString *)appPwd;

- (UIColor  *)adTextColor;
- (UIColor  *)adBackgroundColor;
- (NSString *)adBackgroundImgName;
- (NSString *)logoImgName;
- (BOOL)usingHTML5;

/**
 <=0 - none, <15 - 15, unit: seconds

 @return The interval
 */
- (int)autoRefreshInterval;

/**
 -1  - none, 0 - fix, 1 - random

 @return GradientColorType
 */
- (int)gradientBgType;

- (BOOL)testMode;
- (BOOL)usingCache;
- (BOOL)logMode;
- (int)configVersion;
- (CLLocation*)getLocation;

/**
 move the center of a ad. Etc: return 20.f means move the ad's center down 20px

 @return float
 */
- (float)moveCentr;

/**
 select and uniform scale, should between 0.8 - 1.2

 @return float
 */
- (float)scaleProportion;

/**
 * WKWebview Need to be added to the view in advance
 */
- (void)needPreAddView:(AdViewView *)adview;

/**
 Ad request host.
 
 @return The host
 */
- (NSString *)AdViewViewHost;
@end

@protocol AdViewGDPRProcotolV1 <NSObject>
@optional
/**
 Set to YES if a CMP implementing this specification is present in the application.
 Ideally set by the Publisher as soon as possible but can also be set by the CMP alternatively.

 @return If implementing this specification
 */
- (BOOL)CMPPresent;

/**
 GDPR Applicability
 
 @return allow GDPR
 */
- (BOOL)subjectToGDPR;

/**
 GDPR ConsentString
 
 @return the ConsentString
 */
- (NSString *)userConsentString;

/**
 String (of "0" and "1") where the character in position N indicates the consent status to purpose ID N as defined in the Global Vendor List.
 String of consent given to enable simple checking. First character from the left being Purpose 1, ...

 @return @"0" or @"1"
 */
- (NSString *)parsedPurposeConsents;

/**
 String (of "0" and "1") where the character in position N indicates the consent status to vendor ID N as defined in the Global Vendor List.
 String of consent given to enable simple checking. First character from the left being Vendor 1, ...

 @return @"0" or @"1"
 */
- (NSString *)parsedVendorConsents;

@end

@protocol AdViewGDPRProcotolV2 <NSObject>
@optional
/**
 1 GDPR applies in current context

 0 - GDPR does not apply in current context

 Unset - undetermined (default before initialization)
 */
- (BOOL)GDPRApplies;

/**
 Full encoded TC string
 see https://github.com/InteractiveAdvertisingBureau/GDPR-Transparency-and-Consent-Framework/blob/master/TCFv2/IAB%20Tech%20Lab%20-%20CMP%20API%20v2.md#in-app-details
 */
- (NSString *)TCFString;
@end


@protocol AdViewBidModeProtocol <NSObject>
@optional
/**
 Whether to use bid mode
 @param adViewObject - the object of AdViewView / AdViewVideo / AdViewNativeAd
 @return if YES, you alse to implement the method "adViewObjectDidReceiveBidResult:" or not
 */
- (BOOL)adViewObjectUsedBidMode:(NSObject *)adViewObject;
/**
 Return the price of bidding.
 if win, you should call "[adViewObject bidSuccess]",
 or [adViewObject bidFailed], you must choose one.
 @param adViewObject - the object of AdViewView / AdViewVideo / AdViewNativeAd
 @param price - the price(USD)
 */
- (void)adViewObject:(NSObject *)adViewObject didReceiveBidPrice:(double)price;

/**
 Error when requesting bid price
 @param adViewObject - the object of AdViewView / AdViewVideo / AdViewNativeAd
 @param error - error message
 */
- (void)adViewObject:(NSObject *)adViewObject bidPriceRequestError:(NSError *)error;
@end
